﻿/*
	VERSION:		1.8
	
	DESCRIPTION:
		This is a movieClip-based music system.
		It streams external .mp3 files.
	
	USAGE:
		#include "makeMusic.as"
		MUSIC = makeMusic();
		MUSIC.play( "songName" );
		
		makeStreamingMusic( target_mc:MovieClip, newName:String, [newDepth:Number] );
		
	FUNCTIONS:
		play( "songName" );				// Plays the songName_intro tune, then switches to songName (which should loop)
		playLoop( "songName" );		// Skip any intro's and specifically play the main loo pof the song
		stopMusic();						// Stops the music and forgets the last song
		fadeOut( seconds );				// Fades out, then stops the music
		
	PROPERTIES:
		volume								// scalar (percentage) that gets or sets the maximum playback volume of all music
		innerVolume							// gets or sets the intensity of THIS music  (used for fade-out's)
		
		Playback volume  =  innerVolume * (volume/100)
		To change the volume of all music played, use "volume".
		To change the volume of only the current song, use "innerVolume".
		All songs start playback with an "innerVolume" of 100.
		
	INTROS & LOOPS:
		You may add folders before the fileNames.
		Name your files / linkages like so:
			songName_intro.mp3			play("songName.mp3")				(The extension must be .mp3)
			songName.mp3					playLoop("songName.mp3")			(This is the looping version of the song.)
		When play() is used, it'll automatically attempt to load an intro for the song. If there's no intro, it'll play the loop.
*/



makeStreamingMusic = function( target_mc, newName, newDepth )
{
	// resolve optional parameters
	var target_mc = (target_mc != undefined) ? target_mc : this;
	var newName = (newName != undefined) ? newName : "musicSystem_mc";
	#include "nextDepth.as"
	var newDepth = (newDepth) ? newDepth : nextDepth(target_mc);
	
	// create containers
	var _this = target_mc.createEmptyMovieClip( newName, newDepth );
	_this.music = new Sound();
	_this.volume = 100;
	_this.isPlaying = false;
	_this.songName = "";
	
	
	
	
	
	
	// FUNCTIONS
	_this.play = function( songName )
	{
		if(_this.fade)
		{
			_this.fade.stop();
			delete _this.fade;
			_this.songName = "";
		}// if:  fading-out
		_this.setInnerVolume(100);
		
		if(_this.songName != songName)
		{
			// transition:  intro  ->  loop
			_this.music.onSoundComplete = function()
			{
				// play normally
				var songName = _this.songName;
				_this.songName = "";					// spoof it so it'll play the same song again
				_this.playLoop( songName );		// play the regular (looping) version
			}// onSoundComplete()
			
			// If there is no intro,  immediately play the loop
			_this.music.onLoad = function(success)
			{
				if(!success)
					_this.music.onSoundComplete();
			}// songLoaded()
			
			var nameLength = songName.indexOf(".");
			var introName = songName.substr(0, nameLength) + "_intro" + ".mp3";		// songName.mp3  ->  songName_intro.mp3
			_this.songName = songName;
			_this.isPlaying = false;
			_this.music.loadSound( introName, true );
		}// if: a new song is specified
		
		if( _this.isPlaying == false )
		{
			_this.music.start();
			_this.music.setVolume( _this.volume );
			_this.isPlaying = true;
		}// if:  music is not playing
	}// play()
	
	
	
	_this.playLoop = function( songName )
	{
		if(_this.songName != songName)
		{
			// Looping method
			_this.music.onSoundComplete = function()
			{
				_this.music.start();
			}// onSoundComplete()
			
			// Remove the no-intro detection
			_this.music.onLoad = function(){}
			
			_this.music.loadSound( songName, true );
			_this.songName = songName;
			_this.isPlaying = false;
		}// if: a new song is specified
		
		if( _this.isPlaying == false )
		{
			//_this.music.stop();		// might be redundant
			_this.music.start();
			_this.music.setVolume( _this.volume );
			_this.isPlaying = true;
		}// if:  music is not playing
	}// playLoop()
	
	
	
	/*
	// Alternative looping method
	_this.checkLoop = function()
	{
		var current = _this.music.position;
		var end = _this.music.duration;
		if( current >= end-0 )
		{
			//_this.music.stop();
			_this.music.start();
		}
	}// checkLoop()
	_this.checkLoopInterval = setInterval( _this.checkLoop , 1 );
	_this.onUnload = function()
	{
		clearInterval( _this.checkLoopInterval );
	}// onUnload()
	*/
	
	
	
	_this.stopMusic = function()
	{
		_this.songName = "";
		_this.music.stop();
		_this.isPlaying = false;
	}// stopMusic()
	
	
	
	// setVolume()
	_this.setVolume = function( newVolume )
	{
		_this.music.setVolume( newVolume );
		_this.volume = newVolume;
	}// volume		(set)
	// getVolume()
	_this.getVolume = function()
	{
		return _this.volume;
	}// volume		(get)
	_this.addProperty( "volume", _this.getVolume, _this.setVolume );
	
	
	
	_this.getInnerVolume = function()
	{
		return _this.music.getVolume() / (_this.volume/100);		// song volume  (global volume factored out)
	}// volume		(get)
	_this.setInnerVolume = function( newVolume )
	{
		newVolume *= (_this.volume/100);		// innerVolume * global music volume
		_this.music.setVolume( newVolume );
	}// volume		(set)
	_this.addProperty( "innerVolume", _this.getInnerVolume, _this.setInnerVolume );
	
	
	
	// stop()
	_this.stop = _this.stopMusic;
	
	
	
	_this.fadeOut = function( seconds )
	{
		if(_this.volume > 0  &&
		   _this.fade == undefined)
		{
			// tween volume from current to ZERO
			var startVolume = _this.getInnerVolume();
			_this.fade = new mx.transitions.Tween( _this, "innerVolume", null, startVolume, 0, seconds, true);
			
			// onChange
			_this.fade.onMotionChanged = function()
			{
				_this.setInnerVolume( this.position );
			}// onMotionChanged()
			
			// onDone
			_this.fade.onMotionFinished = function()
			{
				delete _this.fade;
				_this.stop();
			}// onMotionFinished()
		}// if:  volume isn't ZERO
	}// fadeOut()
	
	
	
	return _this;
}// makeStreamingMusic()